/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.curator.framework.imps;

import com.netflix.curator.framework.api.BackgroundCallback;
import com.netflix.curator.framework.imps.BackgroundOperation;

class OperationAndData<T> {
    private final BackgroundOperation<T> operation;
    private final T data;
    private final BackgroundCallback callback;
    private final long startTimeMs = System.currentTimeMillis();
    private int retryCount = 0;

    OperationAndData(BackgroundOperation<T> operation, T data, BackgroundCallback callback) {
        this.operation = operation;
        this.data = data;
        this.callback = callback;
    }

    void callPerformBackgroundOperation() throws Exception {
        this.operation.performBackgroundOperation(this);
    }

    T getData() {
        return this.data;
    }

    long getElapsedTimeMs() {
        return System.currentTimeMillis() - this.startTimeMs;
    }

    int getThenIncrementRetryCount() {
        return this.retryCount++;
    }

    BackgroundCallback getCallback() {
        return this.callback;
    }
}

