/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.curator.framework.listen;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.MoreExecutors;
import com.netflix.curator.framework.listen.Listenable;
import com.netflix.curator.framework.listen.ListenerEntry;
import java.util.Map;
import java.util.concurrent.Executor;

public class ListenerContainer<T>
implements Listenable<T> {
    private final Map<T, ListenerEntry<T>> listeners = Maps.newConcurrentMap();

    @Override
    public void addListener(T listener) {
        this.addListener(listener, (Executor)MoreExecutors.sameThreadExecutor());
    }

    @Override
    public void addListener(T listener, Executor executor) {
        this.listeners.put(listener, new ListenerEntry<T>(listener, executor));
    }

    @Override
    public void removeListener(T listener) {
        this.listeners.remove(listener);
    }

    public void clear() {
        this.listeners.clear();
    }

    public int size() {
        return this.listeners.size();
    }

    public void forEach(Function<T, Void> function) {
        for (ListenerEntry<T> entry : this.listeners.values()) {
            function.apply(entry.listener);
        }
    }
}

